<%@ Language=VBScript %>	 
<%option explicit%>
<!-- #include file="inc/constants.asp"-->
<!-- #include file="inc/vssconst.asp"-->
<!-- #include file="inc/AspUser.asp" -->

<% 
   dim  objVSSdb,objFSO,CommentStr
   CommentStr="by TeamGovenor user: " & Username 

   '--- Create an instance of a Visual Source Database object and FileSystem Object ---
   Set objFSO = server.createObject("Scripting.FileSystemObject")
   Set objVSSdb = CreateObject("SourceSafe")
   objVSSdb.Open SSIni, UserName

   If Request.Form("Mode") = "Scan" Then
      UpdateVSS()
   Else
      CheckInOut()
   End If
   
   '-----------------------------------------------------------------------------------
   ' UpdateVSS synchronizes the Visual SourceSafe databases with the File system:
   '    a.) Add items to VSS, which were added to the file system!
   '    b.) Delete items from VSS, which have been deleted from the File system!
   '-----------------------------------------------------------------------------------
   Sub UpdateVSS()
      Dim s,strPath,rec,iFlags,Item
      For Each Item in Request.Form
         If Request.Form(Item).Count Then
            if left(item,1)="s" then     
			   s="t" & right(item,len(item)-1)
               strPath=Request.Form(s)
			   s="r" & right(item,len(item)-1)
               rec=Request.Form(s)
               if len(rec)>0 then iFlags=VSSFLAG_RECURSYES else iFlags=0
               AddNewItems Replace( DocsDir & strPath,"/","\"), "$"&strPath, iFlags
			   DelOrphantItems Replace( DocsDir & strPath,"/","\"), "$"&strPath, iFlags
			end If
	     End If
      Next
   End Sub
 
   '-----------------------------------------------------------------------------------
   ' AddNewItems scans a Folder and adds new files and folders to Visual SourceSafe
   ' Input:  FSFolder  --> File System Folder to scan
   '         VSSFolder --> SourceSafe Folder ($/...) to which to add new Files
   '         iFlags    --> Performs a recursive scan of all folders if iFlags <> 0
   '-----------------------------------------------------------------------------------
   Sub AddNewItems( ByVAl FSFolder, ByVal VSSFolder, ByVal iFlags)
      Dim vssRoot, objFolder,itemFile,itemFolder,ItemCreator
	  Dim objSubFolder, objSubFolders, objFile, objFiles
	  On Error Resume Next
      Err.Clear
      Set vssRoot=ObjVssdb.vssitem(VSSFolder)
   	  Set objFolder = objFSO.getFolder(FSFolder)
	  Set objSubFolders = objFolder.SubFolders
      Set objFiles = objFolder.Files
	  For each objFile in objFiles
	     Err.Clear
	     set itemFile=ObjVssdb.vssitem(VSSFolder & "/" & objFile.Name )
		 If Err.Number <> 0 Then   'If Item doesn't exist in SourceSafe Error is raised
		    If objFile.Name <> "vssver.scc" Then
			   ItemCreator = getItemCreator(FSFolder & "\" & objFile.Name)
			   If ItemCreator <> "" Then
			      vssRoot.Add FSFolder & "\" & objFile.Name , "by TeamGovenor user: " & ItemCreator, +VSSFLAG_GETNO +VSSFLAG_FORCEDIRYES
			      set itemFile=ObjVssdb.vssitem(VSSFolder & "/" & objFile.Name )
				  itemFile.checkout "by TeamGovenor user: " & ItemCreator, itemFile.LocalSpec , +VSSFLAG_GETNO +VSSFLAG_FORCEDIRYES + iFlags
               End If
			End If
		 End If
	  Next
	  For each objSubFolder in objSubFolders
	    Err.Clear
		set itemFolder=ObjVssdb.vssitem(VSSFolder & "/" & objSubFolder.Name)
        If Err.Number <> 0 Then
		   ItemCreator = getItemCreator(FSFolder & "\" & objSubFolder.Name)
		   If ItemCreator <> "" Then
		      vssRoot.NewSubproject objSubFolder.Name , "by TeamGovenor user: " & ItemCreator
			  AddNewItems FSFolder & "\" & objSubFolder.Name, VSSFolder & "/" & objSubFolder.Name, VSSFLAG_RECURSYES
	       End If
	    Else
		    If iFlags <> 0 Then
			   AddNewItems FSFolder & "\" & objSubFolder.Name, VSSFolder & "/" & objSubFolder.Name, iFlags
			End If
		End If
	  Next
	  Set objFiles = Nothing
	  Set objSubFolders = Nothing
	  Set objFolder = Nothing
	  Set vssRoot = Nothing
   End Sub
   
   '-----------------------------------------------------------------------------------
   ' DelOrphantItems scans a Folder and deletes orphant files and folders in 
   '         the SourceSafe Folder
   ' Input:  FSFolder  --> File System Folder to scan
   '         VSSFolder --> SourceSafe Folder ($/...) which to update
   '         iFlags    --> Performs a recursive scan of all folders if iFlags <> 0
   '-----------------------------------------------------------------------------------
   Sub DelOrphantItems( ByVAl FSFolder, ByVal VSSFolder, ByVal iFlags)
      Dim vssItem,vssRoot,objVSSObject
	  Set vssRoot=ObjVssdb.vssitem(VSSFolder)
	  For each objVSSObject In vssRoot.items
	     If objVSSObject.Type = VSSITEM_FILE Then
		    If objFSO.FileExists(FSFolder & "\" & objVSSObject.Name) = False Then
				Set vssItem = ObjVssdb.vssitem(VSSFolder & "/" & objVSSObject.Name)
				vssItem.Destroy
				Set vssItem = Nothing
			End If
		 Else
		    If objFSO.FolderExists(FSFolder & "\" & objVSSObject.Name) = False Then
			   Set vssItem = ObjVssdb.vssitem(VSSFolder & "/" & objVSSObject.Name)
			   vssItem.Destroy
			   Set vssItem = Nothing
			Else
			   If iFlags <> 0 Then
			      DelOrphantItems FSFolder & "\" & objVSSObject.Name, VSSFolder & "/" & objVSSObject.Name, iFlags
			   End If
			End If
		 End If
	  Next
	  Set vssRoot = Nothing
   End Sub

   '-----------------------------------------------------------------------------------
   ' CheckInOut performs check-in and check-out of selected items (files & folders)
   '-----------------------------------------------------------------------------------
   Sub CheckInOut()
      dim Fname,action,rec,iFlags,s,Item
      action=0
      For Each Item in Request.Form
         If Request.Form(Item).Count Then
            if left(item,1)="o" then     
		       'checked out item: fname contains the file or folder name   
               s="t" & right(item,len(item)-1)
               fName=Request.Form(s)
               if len(Fname)>0 then 
                  s="r" & right(item,len(item)-1)
                  rec=Request.Form(s)
                  if len(rec)>0 then iFlags=VSSFLAG_RECURSYES else iFlags=0
                  CheckOut fName,iFlags
               end if   
            end if   
            if left(item,1)="i" then 
		      'checked out item: fname contains the file or folder name
              s="t" & right(item,len(item)-1)
              fName=Request.Form(s)
              if len(Fname)>0 then 
                 s="r" & right(item,len(item)-1)
                 rec=Request.Form(s)
                 if len(rec)>0 then iFlags=VSSFLAG_RECURSYES else iFlags=0
                    CheckIn fName,iFlags
                 end if   
              end if   
         End If
      Next
   End Sub 

   '-----------------------------------------------------------------------------------
   ' CheckOut: Checks a file or folder out
   ' Input:  Name   --> File or Folder name
   '         iFlags --> Performs a recursive checkout of all folders if iFlags <> 0
   '-----------------------------------------------------------------------------------
   Sub CheckOut( ByVAl Name,byval iFlags)
      dim item
      set item=ObjVssdb.vssitem("$" & Name)
      if item.type = VSSITEM_FILE then 
         item.checkout "by TeamGovenor user: " & Username, item.LocalSpec , +VSSFLAG_GETNO +VSSFLAG_FORCEDIRYES + iFlags
         SetNTFSPermission UserName, "Full", Replace(DocsDir & Name, "/", "\"), "File"
      else 
         item.checkout "by TeamGovenor user: " & Username, item.LocalSpec , +VSSFLAG_GETNO +VSSFLAG_FORCEDIRYES + iFlags
		 SetFolderPermission UserName, "Full", Replace(DocsDir & Name, "/", "\"), "$" & Name, iFlags
      end if 
   End Sub

   '-----------------------------------------------------------------------------------
   ' CheckIn: Checks a file or folder in
   ' Input:  Name   --> File or Folder name
   '         iFlags --> Performs a recursive checkin of all folders if iFlags <> 0
   '-----------------------------------------------------------------------------------
   Sub CheckIn( ByVAl Name,byval iFlags)
      dim item, fso, f  ,s
      set item=ObjVssdb.vssitem("$" & name)
      if item.Type = VSSITEM_FILE Then
         item.checkin CommentStr,item.LocalSpec , +VSSFLAG_FORCEDIRYES +VSSFLAG_KEEPYES +iFlags
         SetNTFSPermission UserName, "Revoke", Replace(DocsDir & Name, "/", "\"), "File"
      else 
         SetFolderPermission UserName, "Revoke", Replace(DocsDir & Name, "/", "\"), "$" & Name, iFlags
		 item.checkin CommentStr,item.LocalSpec, +VSSFLAG_FORCEDIRYES +VSSFLAG_KEEPYES +iFlags
      end if 
   End Sub
   
   '-----------------------------------------------------------------------------------
   ' SetFolderPermission: Checks all items in the current folder (including the folder
   '        itself) whether the item is checked out by the current user. Depending on the
   '        Permissions variable the following actions are performed:
   '        a.) Permission = "Full": If the file/folder is checked out by the current
   '            user, he gets full access to the item, but only if he doesn't already
   '            have full access!
   '        b.) Permission = "Revoke": Full access to the item is taken away from the
   '            current user
   ' Input: User, Permission("Full" or "Revoke"), FSFolder(File System Folder to check),
   '        VSSFolder(repective SourceSafe Folder), iFlag(recursive if unequal 0)
   '-----------------------------------------------------------------------------------
   Sub SetFolderPermission(ByVal User, ByVal Permission, ByVal FSFolder, ByVal VSSFolder, ByVal iFlags)
      Dim vssRoot, objVSSObject
	  'Check/Set Permissions on the current folder
	  CheckSetFolderItemPermission FSFolder, Permission, "Folder"
	  Set vssRoot=ObjVssdb.vssitem(VSSFolder)
	  For each objVSSObject In vssRoot.items
	     If objVSSObject.Type = VSSITEM_FILE Then
	        If objVSSObject.IsCheckedOut = VSSFILE_CHECKEDOUT_ME  Then
		       'Check/Set Permission if the file is checked out by the current user
	           CheckSetFolderItemPermission FSFolder & "\" & objVSSObject.Name, Permission, "File"
	        End If
		 Else
		    CheckSetFolderItemPermission FSFolder & "\" & objVSSObject.Name, Permission, "Folder"
		    If iFlags <> 0 Then
			   'Check/Set all Folders within the current Folder recursively if the recursive flag is set
               SetFolderPermission User, Permission, FSFolder & "\" & objVSSObject.Name, VSSFolder & "/" & objVSSObject.Name, iFlags
			End If
		 End If
	  Next
   End Sub
   
   '-----------------------------------------------------------------------------------
   ' CheckSetFolderItemPermission: Checks if the user has full access to an item 
   '        (File or Folder). Depending on the Permissions variable the following 
   '        actions are performed:
   '        a.) Permission = "Full": If the file/folder is checked out by the current
   '            user, he gets full access to the item, if he not already has full access!
   '        b.) Permission = "Revoke": Full access to the item is taken away for the
   '            current user
   ' Input: ItemName, Permission("Full" or "Revoke"), ItemType("File" or "Folder")
   '-----------------------------------------------------------------------------------
   Sub CheckSetFolderItemPermission(ByVal ItemName, ByVal Permission, ByVal ItemType)
      Dim Au, Ace, blnFound, Item, i, AceUser, blnDone
	  Set Au = Server.CreateObject("Persits.AspUser")
      Set Item = Au.File(ItemName)
	  blnFound = 0
	  blnDone  = 0
	  For i = 1 to Item.AllowanceCount
         Set Ace = Item.GetAllowanceAce(i)
		 AceUser = LCase(Ace.AccountName)
		 If AceUser = LCase(Username) Then
            blnFound = 1
		 Else
		    'Check if Folder is checked out by another User; if yes, don't touch it!
			If ItemType = "Folder" Then
		       If AceUser <> LCase(AdminUser) AND AceUser <> LCase(EveryoneUser) AND AceUser <> LCase(ReplicationUser) Then
			      blnDone = 1
			      Exit For
			   End If
		    End If
		 End If
      Next
	  If blnDone = 0 Then
	     If Permission = "Full" AND blnFound = 0 Then     
	        'Give full access to file or folder to the current user
		    SetNTFSPermission Username, "Full", ItemName, ItemType
         Else
		    If Permission = "Revoke" AND blnFound = 1 Then
		       'Take full access from file or folder away from the current user
			   SetNTFSPermission Username, "Revoke", ItemName, ItemType
       	    End If
	     End If
      End If
   End Sub
   
   '-----------------------------------------------------------------------------------
   ' SetNTFSPermission:  Sets the appropriate permissions on a file or folder:
   '         Checkout:   Give user full access & the user replication no access to a file
   '         Checkin:    Give user read access & the user replication full access to a file
   ' Input:  User       --> Username
   '         Permission --> Permission to set: Read, Full or Revoke
   '                        Revoke = Take full permission away from the user.
   '         FileName   --> File or Folder Name
   '         Type       --> File or Folder
   '-----------------------------------------------------------------------------------
   Sub SetNTFSPermission(ByVal User, ByVal Permission, ByVal FileName, ByVal ItemType)
      Dim Au, File
	  Err.Clear
      Set Au = Server.CreateObject("Persits.AspUser")
	  Set File = Au.File(FileName)
      Select Case Permission
	     Case "Read"   
		     ' Give user read and execute access to the file/folder
			 ' Remove NoAccess for Replication user 
		     File.AllowAccess User, GENERIC_READ + FILE_GENERIC_EXECUTE
             If ItemType = "File" Then
			    File.RevokeDenial ReplicationUser
			 End If
	     Case "Full"     
		     ' Grant user full access to the file/folder
			 ' Deny access for Replication user
		     File.AllowAccess User, GENERIC_ALL
             If ItemType = "File" Then
			    File.DenyAccess ReplicationUser, GENERIC_ALL
			 End If
         Case "Revoke"   
		     'Take Full access away from user for the file/folder
			 'Remove NoAccess for the Replication user
		     File.RevokeAllowance User
             If ItemType = "File" Then
                File.RevokeDenial ReplicationUser
			 End If
	  End Select
   End Sub
   
   '-----------------------------------------------------------------------------------
   ' getItemCreator: Returns the Username that created the file or folder
   ' Input:  ItemName --> File or Folder name
   '-----------------------------------------------------------------------------------
   Function getItemCreator(ByVal ItemName)
      Dim Au, Item, Ace, AceUser, ItemCreator,i
	  ItemCreator = ""
	  Set Au = Server.CreateObject("Persits.AspUser")
      Set Item = Au.File(ItemName)
	  For i = 1 to Item.AllowanceCount
         Set Ace = Item.GetAllowanceAce(i)
		 AceUser = LCase(Ace.AccountName)
		 If AceUser <> LCase(AdminUser) AND AceUser <> LCase(EveryoneUser) AND AceUser <> LCase(ReplicationUser) Then
		    ItemCreator = AceUser
			Exit For
		 End If
	  Next
	  getItemCreator = ItemCreator
   End Function
   
   '-----------------------------------------------------------------------------------
   ' backSlash: Replace / replace with \
   ' Input:  s  -->  Path string
   '-----------------------------------------------------------------------------------
   Function backSlash(byval s)
      dim t
      for t= 1 to len(s) 
         if mid(s,t,1)="/" then s=left(s,t-1) & "\" & right(s,len(s)-t)
      next
      backSlash=s
   End function
%>

<HTML>
<HEAD>
<Title>Submit</title>
</HEAD>
<SCRIPT LANGUAGE="JavaScript">
<!--
   function goBack(){
      document.location.replace("default.asp?cp=<%=Request.Form("parent")%>");
	  return(true);
   }
-->
</SCRIPT>
<BODY onLoad="return goBack();">
</BODY>
</HTML>
